#include "storage.h"
#include "storage_impl.h"

#include <yplatform/module_registration.h>

namespace NRateSrv::NStorage {

TStorage::TStorage()
    : Impl(std::make_unique<TStorageImpl>())
{}

void TStorage::init(const yplatform::ptree& configuration) {
    Impl->logger(logger());
    Impl->Init(configuration);
}

void TStorage::stop() {
    Impl->Stop();
}

TResponse TStorage::Get(TRequest request) {
    return Impl->Get(std::move(request));
}

TResponse TStorage::Increase(TRequest request) {
    return Impl->Increase(std::move(request));
}

} // namespace NRateSrv::NStorage

REGISTER_MODULE(NRateSrv::NStorage::TStorage)
