#pragma once

#include "interface.h"
#include "protocol.h"

#include <yplatform/module.h>
#include <yplatform/ptree.h>

#include <memory>

namespace NRateSrv::NStorage {

class TStorageImpl;

class TStorage : public IStorage, public yplatform::module {
public:
    TStorage();

    void init(const yplatform::ptree& configuration);
    void stop();

    TResponse Get(TRequest request) override;
    TResponse Increase(TRequest request) override;

private:
    std::unique_ptr<TStorageImpl> Impl;
};

} // namespace NRateSrv::NStorage
