#pragma once

#include "repository.h"

#include <memory>
#include <string>

namespace NRateSrv::NStorage {

class ISynchronizer {
public:
    virtual ~ISynchronizer() = default;

    virtual void Add(const std::string& group, const std::string& limit, TInterval ttl, TRepositoryPtr repository) = 0;
    virtual void Sync() = 0;
};

using TSynchronizerPtr = std::unique_ptr<ISynchronizer>;

} // namespace NRateSrv::NStorage
