#include "tvm_check.h"

#include <ymod_tvm/module.h>
#include <yplatform/find.h>

namespace NRateSrv {

std::pair<bool, std::string> CheckTvm(ymod_webserver::request_ptr request) {
    auto it = request->headers.find("x-ya-service-ticket");
    if (it == request->headers.end()) {
        return {true, {}};
    }

    auto tvm = yplatform::find<ymod_tvm::tvm2_module>("tvm");
    auto ticket = tvm->get_native_service_ticket(request->ctx(), it->second);

    if (ticket == boost::none) {
        return {false, {}};
    }

    std::string src;
    if (ticket->GetStatus() == 0) {
        src = std::to_string(ticket->GetSrc());
    }

    return {true, std::move(src)};
}

} // namespace NRateSrv
