LIBRARY()

OWNER(
    g:mproto
)

PEERDIR(
    contrib/libs/yaml-cpp
    library/cpp/consistent_hashing
    library/cpp/json
    mail/ymod_messenger
    mail/ymod_webserver
    mail/ymod_tvm
    mail/ymod_httpclient
    mail/yplatform/lib
    mail/logdog
)

ADDINCL(
    mail/yplatform/include
    mail/logdog/include
)

SRCS(
    GLOBAL ratesrv.cpp
    GLOBAL scheduler/scheduler.cpp
    GLOBAL storage/storage.cpp
    GLOBAL router/router.cpp
    tvm_check.cpp
    common/input_segment_stream.cpp
    common/output_string_stream.cpp
    handlers/http/ping.cpp
    handlers/http/counters_get.cpp
    handlers/http/counters_increase.cpp
    handlers/json/request_parser.cpp
    handlers/json/callbacks.cpp
    handlers/json/get_callbacks.cpp
    handlers/json/increase_callbacks.cpp
    handlers/json/response_maker.cpp
    handlers/counters_worker.cpp
    instances/checker/host_checker_impl.cpp
    instances/qloud/host_getter_impl.cpp
    instances/qloud/errors.cpp
    instances/qloud/parser.cpp
    instances/hostlist_builder.cpp
    instances/task.cpp
    storage/counter_updater.cpp
    storage/repository.cpp
    storage/database.cpp
    storage/gc_task.cpp
    router/counters_worker.cpp
    router/storage_client.cpp
    router/network_agent_impl.cpp
    router/messenger_request_handler.cpp
    router/node.cpp
    router/node_client.cpp
    router/node_manager.cpp
    router/router_impl.cpp
    router/util.cpp
)

GENERATE_ENUM_SERIALIZATION(common/types.h)

END()
