#pragma once

#include <mail/unistat/cpp/include/common_logs.h>

#include <boost/lexical_cast.hpp>

#include <variant>

namespace unistat {

class CounterMeter {
public:
    CounterMeter(std::string counterName, std::string sigoptSuffix = "summ") 
        : CounterName(std::move(counterName))
        , SigoptSuffix(std::move(sigoptSuffix)) {
    }

    void update(const std::map<std::string, std::string>& tskvData) {
        auto counterNameIt = tskvData.find("counter_name");
        auto counterValueIt = tskvData.find("counter_value");
        if (counterNameIt != tskvData.end() && counterValueIt != tskvData.end() && counterNameIt->second == CounterName) {
            auto val = boost::lexical_cast<std::size_t>(counterValueIt->second);

            if (SigoptSuffix == "summ") {
                Value += val;
            } else {
                Value = val;
            }
        }
    }

    NamedValue<std::size_t> get() const {
        return {withSigoptSuffix(CounterName, SigoptSuffix), Value};
    }

private:
    std::string CounterName;
    std::string SigoptSuffix;
    std::size_t Value = 0;
};

using ServiceMeters = std::variant<std::shared_ptr<CounterMeter>>;
using ServiceLog = Log<TextFileReader, File, TskvParser, ServiceMeters>;
using ServiceLogPtr = std::shared_ptr<ServiceLog>;

using Logs = std::variant<::unistat::AccessTskvPtr, ::unistat::HttpClientLogPtr, ServiceLogPtr>;

}
