from library.python.testing.recipe import declare_recipe
from yatest.common import work_path, build_path, source_path, output_path
from mail.unistat.cpp.cython.canonize.recipe import find_free_port, start_unistat, stop_unistat, source_path_with_prefix, output_path_with_prefix

import os
from shutil import copyfile


def start_service_unistat(argv):
    port = find_free_port()

    prefix = 'mail/ratesrv/unistat/cython/canonize/data'
    script_path = source_path('mail/ratesrv/unistat/cython/service_unistat.py')
    unistat_cmd = f"{build_path('mail/ratesrv/unistat/cython/cunistat')} {script_path} -d {output_path('')} -H '::' -p {str(port)}" \
                  f" -l {work_path('unistat.log')} {source_path_with_prefix(prefix, 'config.yml')}"

    logs = ['ratesrv.tskv', 'access.log', 'http_client.tskv']
    os.makedirs(output_path(prefix), exist_ok=True)

    for name in logs:
        src = source_path_with_prefix(prefix, name)
        dst = output_path_with_prefix(prefix, name)
        copyfile(src, dst)

    file_names = [
        output_path_with_prefix(prefix, name) for name in logs
    ]

    start_unistat(script_path, unistat_cmd, file_names, port, files_is_data_files=False, iterations=10)


if __name__ == "__main__":
    declare_recipe(start_service_unistat, stop_unistat)
