cimport cpp_defs

from libcpp.memory cimport shared_ptr
from libcpp.vector cimport vector
from mail.unistat.cpp.cython.logs cimport *
cimport mail.unistat.cpp.cython.run_cpp

from cpython cimport *

cdef class CounterMeter:
    cdef shared_ptr[cpp_defs.CounterMeter]  __impl

    def __cinit__(self, bytes name, bytes suffix):
        self.__impl.reset(new cpp_defs.CounterMeter(<const char*>name, <const char*>suffix))


cdef class ServiceLog:
    cdef shared_ptr[cpp_defs.ServiceLog] __impl

    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[cpp_defs.ServiceMeters] cm
        for m in cppMeters:
            if isinstance(m, CounterMeter):
                cm.push_back(cpp_defs.ServiceMeters((<CounterMeter>m).__impl))
            else:
                raise AttributeError("Unknown meter type for ServiceLog")
        self.__impl.reset(new cpp_defs.ServiceLog(pm, cm, fastForward, <const char*>path))


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[cpp_defs.Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, AccessTskv):
            cppLogs.push_back(
                cpp_defs.Logs((<AccessTskv>l).__impl)
            )
        elif isinstance(l, ServiceLog):
            cppLogs.push_back(
                cpp_defs.Logs((<ServiceLog>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                cpp_defs.Logs((<HttpClientLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)

