#include <mail/ratesrv/src/common/input_segment_stream.h>

#include <yplatform/zerocopy/streambuf.h>

#include <util/generic/string.h>

#include <gtest/gtest.h>

#include <iostream>
#include <sstream>

namespace {

using namespace NRateSrv;

TEST(TTestInputSegmentStream, Read) {
    yplatform::zerocopy::streambuf buffer(32, 32);
    std::ostream stream(&buffer);
    std::stringstream ss;

    for (char i = 'a'; i < 'z'; ++i) {
        stream << i;
        ss << i;
    }
    for (int i = 0; i < 1000; ++i) {
        stream << "test";
        ss << "test";
    }

    stream << std::flush;
    ss << std::flush;

    auto segment = buffer.detach(buffer.end());
    TInputSegmentStream inputSegmentStream(segment);
    TString res;
    inputSegmentStream >> res;

    EXPECT_EQ(res.data(), ss.str());
}

}
