#include <mail/ratesrv/src/handlers/json/response_maker.h>
#include <mail/ratesrv/src/common/input_segment_stream.h>

#include <yplatform/zerocopy/streambuf.h>

#include <library/cpp/json/json_reader.h>

#include <util/string/cast.h>

#include <gtest/gtest.h>

namespace {

using namespace testing;
using namespace NRateSrv;
using namespace NRateSrv::NHandlers::NJson;
using namespace ::NJson;

class TTestResponseMaker : public Test {
protected:
    TJsonValue MakeJsonValue(const TCounterResponse& response) {
        yplatform::zerocopy::streambuf buffer(512, 512);
        std::ostream stream(&buffer);
        stream << MakeCounterValuesResponse(response) << std::flush;
        auto segment = buffer.detach(buffer.end());
        TInputSegmentStream inputSegmentStream(segment);

        return ReadJsonTree(&inputSegmentStream, true);
    }

    void CheckJsonValue(const TJsonValue::TMapType& map, const TCounterValue& value) {
        bool isError = true;
        std::string status = "error";

        if (value.State == ECounterState::Ok) {
            isError = false;
            status = "ok";
        } else if (value.State == ECounterState::Exceeded) {
            isError = false;
            status = "exceeded";
        }

        ASSERT_EQ(map.size(), (isError ? 2u : 3u));
        ASSERT_EQ(map.at("status").GetString(), status.c_str());

        if (!isError) {
            ASSERT_EQ(map.at("current").GetUInteger(), value.Current);
            ASSERT_EQ(map.at("available").GetInteger(), value.Available);
        } else {
            ASSERT_EQ(map.at("description").GetString(), ToString(value.State));
        }
    }
};

TEST_F(TTestResponseMaker, Emtpy) {
    TCounterResponse response;
    auto jsonValue = MakeJsonValue(response);

    ASSERT_TRUE(jsonValue.Has("counters"));
    ASSERT_TRUE(jsonValue["counters"].GetMap().empty());
}

TEST_F(TTestResponseMaker, AllCounterValueStates) {
    TCounterResponse response;
    response.emplace("id1", TCounterValue{ECounterState::Ok, 10, 100});
    response.emplace("id2", TCounterValue{ECounterState::Exceeded, 20, -10});
    response.emplace("id3", TCounterValue{ECounterState::InvalidName, 0, 0});
    response.emplace("id4", TCounterValue{ECounterState::GroupNotFound, 0, 0});
    response.emplace("id5", TCounterValue{ECounterState::LimitNotFound, 0, 0});
    response.emplace("id6", TCounterValue{ECounterState::NetworkProblem, 0, 0});
    response.emplace("id7", TCounterValue{ECounterState::Unknown, 0, 0});
    auto jsonValue = MakeJsonValue(response);

    ASSERT_TRUE(jsonValue.Has("counters"));
    auto counterMap = jsonValue["counters"].GetMap();

    ASSERT_EQ(counterMap.size(), response.size());

    CheckJsonValue(counterMap["id1"].GetMap(), response["id1"]);
    CheckJsonValue(counterMap["id2"].GetMap(), response["id2"]);
    CheckJsonValue(counterMap["id3"].GetMap(), response["id3"]);
    CheckJsonValue(counterMap["id4"].GetMap(), response["id4"]);
    CheckJsonValue(counterMap["id5"].GetMap(), response["id5"]);
    CheckJsonValue(counterMap["id6"].GetMap(), response["id6"]);
    CheckJsonValue(counterMap["id7"].GetMap(), response["id7"]);
}

}
