#pragma once

#include <yplatform/application.h>

#include <memory>
#include <string>

namespace NRateSrv::NMock {

const std::string applicationConfigStr = R"(
config:
    system:
        daemon: 0
        reactor:
        -   { _io_threads: 1, _pool_count: 2, _name: global }
        -   { _io_threads: 1, _pool_count: 1, _name: storage }
    log:
        global:
            level: off
            sinks:
            -   type: stdout
        requests:
            level: off
            sinks:
            -   type: stdout
    modules:
        module:
        -   _name: storage
            system:
                name: storage
                factory: NRateSrv::NMock::TStorage
            configuration:
                reactor: storage
)";

class TApplication {
public:
    ~TApplication() {
        Application->stop();
    }

    TApplication(const TApplication& other) = delete;
    TApplication& operator=(const TApplication& other) = delete;

    static TApplication& Instance() {
        static TApplication application;
        return application;
    }

private:
    TApplication() {
        yplatform::configuration config;
        config.load_from_str(applicationConfigStr);
        Application = std::make_unique<yplatform::application>(config);
        Application->run();
    }

private:
    std::unique_ptr<yplatform::application> Application;
};

} // namespace NRateSrv::NMock
