#pragma once

#include <ymod_httpclient/call.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NRateSrv::NMock {

using yhttp::options;
using yhttp::request;
using yhttp::response;

struct THttpClientMock : yhttp::simple_call {
    using task_context_ptr = yhttp::simple_call::task_context_ptr;
    using callback_type = yhttp::simple_call::callback_type;

    MOCK_METHOD(response, run, (task_context_ptr, request), (override));
    MOCK_METHOD(response, run, (task_context_ptr, request, const options&), (override));

    MOCK_METHOD(void, async_run, (task_context_ptr, request, callback_type), (override));
    MOCK_METHOD(void, async_run, (task_context_ptr, request, const options&, callback_type), (override));
};

} // namespace NRateSrv::NMock
