#include "storage.h"

#include <yplatform/module_registration.h>

namespace NRateSrv::NMock {

NStorage::TResponse TStorage::Get(NStorage::TRequest request) {
    if (GetCallback) {
        return GetCallback(std::move(request));
    }
    return {};
}

NStorage::TResponse TStorage::Increase(NStorage::TRequest request) {
    if (IncreaseCallback) {
        return IncreaseCallback(std::move(request));
    }
    return {};
}

void TStorage::SetGetCallback(TCallback callback) {
    GetCallback = std::move(callback);
}

void TStorage::SetIncreaseCallback(TCallback callback) {
    IncreaseCallback = std::move(callback);
}

} // namespace NRateSrv::NMock

REGISTER_MODULE(NRateSrv::NMock::TStorage)
