#pragma once

#include <mail/ratesrv/src/storage/interface.h>

#include <yplatform/module.h>

#include <functional>

namespace NRateSrv::NMock {

class TStorage : public NStorage::IStorage, public yplatform::module {
public:
    using TCallback = std::function<NStorage::TResponse(NStorage::TRequest request)>;

    TStorage() = default;

    NStorage::TResponse Get(NStorage::TRequest request) override;
    NStorage::TResponse Increase(NStorage::TRequest request) override;

    void SetGetCallback(TCallback callback);
    void SetIncreaseCallback(TCallback callback);

private:
    TCallback GetCallback;
    TCallback IncreaseCallback;
};

} // namespace NRateSrv::NMock
