#include <mail/ratesrv/src/router/node_manager.h>

#include <yplatform/time_traits.h>

#include <gtest/gtest.h>

namespace {

using namespace testing;
using namespace NRateSrv::NRouter;

TEST(TTestNodeManager, Empty) {
    TNodeManager manager({});
    EXPECT_EQ(manager.Count(), 0u);
}

TEST(TTestNodeManager, GetNode) {
    TNodeManager::TNodes nodes{{"address1", false}, {"address2", true}, {"address3", false}};
    TNodeManager manager(std::move(nodes));

    EXPECT_EQ(manager.Count(), 3u);

    const auto& node1 = manager.Get(0);
    const auto& node2 = manager.Get(1);
    const auto& node3 = manager.Get(2);

    EXPECT_FALSE(node1.IsLocal());
    EXPECT_TRUE(node2.IsLocal());
    EXPECT_FALSE(node3.IsLocal());
    EXPECT_EQ(node1.GetAddress(), "address1");
    EXPECT_EQ(node2.GetAddress(), "address2");
    EXPECT_EQ(node3.GetAddress(), "address3");
}

TEST(TTestNodeManager, GetActingWithLocalNode) {
    TNodeManager::TNodes nodes{{"address1", false}, {"address2", false}, {"address3", true}, {"address4", false}};
    const auto banDuration = yplatform::time_traits::seconds(1000);
    const size_t quorum = 1;
    TNodeManager manager(std::move(nodes));
    bool success;
    size_t nodeNum;

    EXPECT_EQ(manager.Count(), 4u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 1u);

    manager.Get(1).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    manager.Get(0).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(0, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 3u);

    manager.Get(3).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(0, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(2, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(3, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    EXPECT_EQ(manager.Get(0).ResetBan(false), 1);
    std::tie(success, nodeNum) = manager.GetActing(0, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    EXPECT_EQ(manager.Get(1).ResetBan(false), 1);
    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 1u);

    EXPECT_EQ(manager.Get(3).ResetBan(false), 1);
    std::tie(success, nodeNum) = manager.GetActing(3, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 3u);
}

TEST(TTestNodeManager, GetActingWithoutLocalNode) {
    TNodeManager::TNodes nodes{{"address1", false}, {"address2", false}, {"address3", false}, {"address4", false}};
    const auto banDuration = yplatform::time_traits::seconds(1000);
    const size_t quorum = 1;
    TNodeManager manager(std::move(nodes));
    bool success;
    size_t nodeNum;

    EXPECT_EQ(manager.Count(), 4u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 1u);

    manager.Get(1).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    manager.Get(3).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(3, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    manager.Get(2).Ban(banDuration, quorum, false);

    std::tie(success, nodeNum) = manager.GetActing(0, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    std::tie(success, nodeNum) = manager.GetActing(2, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    std::tie(success, nodeNum) = manager.GetActing(3, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 0u);

    manager.Get(0).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(0, {});
    EXPECT_FALSE(success);
}

TEST(TTestNodeManager, GetActingWithUsedNodes) {
    TNodeManager::TNodes nodes{{"address1", false}, {"address2", false}, {"address3", false}, {"address4", false}};
    const auto banDuration = yplatform::time_traits::seconds(1000);
    const size_t quorum = 1;
    TNodeManager manager(std::move(nodes));
    bool success;
    size_t nodeNum;

    EXPECT_EQ(manager.Count(), 4u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 1u);

    std::tie(success, nodeNum) = manager.GetActing(1, {1});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 1u);

    manager.Get(1).Ban(banDuration, quorum, false);
    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(1, {1});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(1, {2});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 3u);

    std::tie(success, nodeNum) = manager.GetActing(1, {});
    EXPECT_TRUE(success);
    EXPECT_EQ(nodeNum, 2u);

    std::tie(success, nodeNum) = manager.GetActing(0, {0, 1, 2, 3});
    EXPECT_FALSE(success);
}

}
