#include <mail/ratesrv/src/router/node.h>

#include <yplatform/time_traits.h>

#include <gtest/gtest.h>

#include <thread>

namespace {

using namespace testing;
using namespace NRateSrv::NRouter;

TEST(TTestNode, Create) {
    {
        TNode node("address1", true);
        EXPECT_EQ(node.GetAddress(), "address1");
        EXPECT_TRUE(node.IsLocal());
    }

    {
        TNode node("address2", false);
        EXPECT_EQ(node.GetAddress(), "address2");
        EXPECT_FALSE(node.IsLocal());
    }

    {
        TNode node({}, false);
        EXPECT_EQ(node.GetAddress(), "");
        EXPECT_FALSE(node.IsLocal());
    }
}

TEST(TTestNode, Ban) {
    TNode node("address", false);
    EXPECT_FALSE(node.IsBanned());

    auto baseDuration = yplatform::time_traits::seconds(1);
    size_t quorum = 3;

    auto duration = TNode::TDuration::zero();
    for (size_t i = 0; i < quorum; ++i) {
        EXPECT_FALSE(node.IsBanned());
        EXPECT_EQ(duration.count(), 0u);
        duration = node.Ban(baseDuration, quorum, false);
    }

    EXPECT_EQ(duration.count(), TNode::CalcBanDuration(baseDuration, 0).count());

    int banNumber = 0;
    for (size_t i = 0; i < quorum; ++i) {
        EXPECT_TRUE(node.IsBanned());
        EXPECT_EQ(banNumber, 0);
        banNumber = node.ResetBan(false);
    }

    EXPECT_FALSE(node.IsBanned());
    EXPECT_EQ(banNumber, 1);

    for (size_t i = 0; i < quorum; ++i) {
        duration = node.Ban(baseDuration, quorum, false);
    }
    auto zeroDuration = node.Ban(baseDuration, quorum, false);

    EXPECT_TRUE(node.IsBanned());
    EXPECT_EQ(duration.count(), TNode::CalcBanDuration(baseDuration, 0).count());
    EXPECT_EQ(zeroDuration.count(), 0u);
    EXPECT_FALSE(node.AllowTryToResetBan());

    std::this_thread::sleep_for(duration);

    for (size_t i = 0; i < quorum; ++i) {
        EXPECT_TRUE(node.IsBanned());
        EXPECT_TRUE(node.AllowTryToResetBan());
        node.ResetBan(false);
    }

    EXPECT_FALSE(node.IsBanned());

    duration = node.Ban(baseDuration, 1, false);
    EXPECT_TRUE(node.IsBanned());

    std::this_thread::sleep_for(duration);

    duration = node.Ban(baseDuration, 1, false);
    EXPECT_TRUE(node.IsBanned());

    EXPECT_EQ(duration.count(), TNode::CalcBanDuration(baseDuration, 1).count());

    banNumber = node.ResetBan(true);
    EXPECT_FALSE(node.IsBanned());
    EXPECT_EQ(banNumber, 2);

    duration = node.Ban(baseDuration, quorum, true);
    EXPECT_TRUE(node.IsBanned());
    EXPECT_EQ(duration.count(), TNode::CalcBanDuration(baseDuration, 0).count());
}

}
