#include <mail/ratesrv/src/router/storage_client.h>

#include <mail/ratesrv/ut/mock/application.h>
#include <mail/ratesrv/ut/mock/storage.h>

#include <yplatform/find.h>
#include <yplatform/yield.h>

#include <gtest/gtest.h>

#include <condition_variable>
#include <mutex>
#include <memory>

namespace {

using namespace testing;
using namespace NRateSrv;
using namespace NRateSrv::NMock;

class TTestStorageClient : public Test {
protected:
    void SetUp() override {
        Request.Add("group", "limit", "domain", "key", 10, 20, 30);
        Response.emplace(40, TCounterValue{ECounterState::Ok, 100, 200});
    }

    bool RunClient(bool isIncrease) {
        bool success = false;

        TApplication::Instance();
        auto storage = yplatform::find<TStorage>("storage");
        storage->SetGetCallback([this, isIncrease](NStorage::TRequest request) -> NStorage::TResponse {
            if (Request == request && !isIncrease) {
                return Response;
            }
            return {};
        });
        storage->SetIncreaseCallback([this, isIncrease](NStorage::TRequest request) -> NStorage::TResponse {
            if (Request == request && isIncrease) {
                return Response;
            }
            return {};
        });

        auto storageClient = std::make_shared<NRouter::TStorageClient>(
            Request,
            isIncrease ? ERequestMode::Increase : ERequestMode::Get,
            [&origResponse = Response, &success, this](NStorage::TResponse response) {
                success = (origResponse == response);
                SetDone();
            }
        );

        yplatform::spawn(storageClient);
        WaitDone();

        return success;
    }

private:
    void SetDone() {
        {
            std::lock_guard lock(Mutex);
            Done = true;
        }
        Cv.notify_one();
    }

    void WaitDone() {
        std::unique_lock lock(Mutex);
        Cv.wait(lock, [&done = Done]{ return done; });
    }

private:
    std::mutex Mutex;
    std::condition_variable Cv;
    bool Done = false;
    NStorage::TRequest Request;
    NStorage::TResponse Response;
};

TEST_F(TTestStorageClient, Get) {
    ASSERT_TRUE(RunClient(false));
}

TEST_F(TTestStorageClient, Increase) {
    ASSERT_TRUE(RunClient(true));
}

}
