#include <mail/ratesrv/src/router/util.h>

#include <gtest/gtest.h>

#include <unordered_set>

namespace {

using namespace testing;
using namespace NRateSrv::NRouter;

TEST(TTestUtil, SplitNameWithDomain) {
    TSplitName res;
    ASSERT_TRUE(SplitName("group:limit@domain:key", res));

    EXPECT_EQ(res.Group, "group");
    EXPECT_EQ(res.Limit, "limit");
    EXPECT_EQ(res.Domain, "domain");
    EXPECT_EQ(res.Key, "key");
}

TEST(TTestUtil, SplitNameWithoutDomain) {
    TSplitName res;
    ASSERT_TRUE(SplitName("group:limit:key", res));

    EXPECT_EQ(res.Group, "group");
    EXPECT_EQ(res.Limit, "limit");
    EXPECT_EQ(res.Domain, "");
    EXPECT_EQ(res.Key, "key");
}

TEST(TTestUtil, SplitInvalidName) {
    TSplitName res;

    EXPECT_FALSE(SplitName("abracadabra", res));
    EXPECT_FALSE(SplitName("group:", res));
    EXPECT_FALSE(SplitName("group:limit", res));
    EXPECT_FALSE(SplitName("group:limit:", res));
    EXPECT_FALSE(SplitName(":limit:key", res));
    EXPECT_FALSE(SplitName("group::key", res));
}

TEST(TTestUtil, CalcBucketNumber) {
    const size_t bucketCount = 10000;
    const ui64 seed = 100;

    EXPECT_LT(CalcBucketNumber("group:limit:key", bucketCount, seed), bucketCount);
}

TEST(TTestUtil, CalcNodeNumber) {
    const size_t bucket = 100;
    const size_t nodeCount = 10;
    const std::string salt = "ratesrv";
    const ui64 seed = 100;

    EXPECT_LT(CalcNodeNumber(bucket, nodeCount, salt, seed), nodeCount);
}

}
