include(find_recipient_parser_dependencies)

if(RECIPIENT_PARSER_INCLUDE_DIR)
  set(RECIPIENT_PARSER_FIND_QUIETLY TRUE)
endif()

find_path(RECIPIENT_PARSER_INCLUDE_DIR
  NAMES recipient_parser/addr_spec.hpp
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_recipient_parser_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(RECIPIENT_PARSER DEFAULT_MSG
  RECIPIENT_PARSER_INCLUDE_DIR)

if(RECIPIENT_PARSER_FOUND)
  list(APPEND RECIPIENT_PARSER_INCLUDE_DIR ${RECIPIENT_PARSER_DEPENDENCY_INCLUDE_DIRS})
  list(APPEND RECIPIENT_PARSER_LIBRARIES ${RECIPIENT_PARSER_DEPENDENCY_LIBRARIES})
endif()

mark_as_advanced(RECIPIENT_PARSER_INCLUDE_DIR RECIPIENT_PARSER_LIBRARIES)
