from library.python.testing.recipe import declare_recipe
from mail.devpack.lib.recipe import get_cfg, get_coordinator
from mail.callmeback.devpack.components.root import Callmeback
from mail.devpack.lib.components.base import BaseComponent, WithPort
import yaml
import sys


class Reminders(BaseComponent, WithPort):
    NAME = "reminders"
    DEPS = [Callmeback]

    def __init__(self, env, components):
        super(Reminders, self).__init__(env, components)

    def start(self):
        pass

    def stop(self):
        pass


# noinspection PyUnusedLocal
def start(argv):
    cfg = get_cfg(top_comp_cls=Reminders)

    with open('devpack-config.yaml', 'w') as f:
        callmeback_dump = yaml.dump(cfg)
        f.write(callmeback_dump)
        _log("Writing to devpack-config.yaml...")
        _log("Callmeback config is %s" % callmeback_dump)

    _log("Starting the callmeback instance...")
    get_coordinator(cfg, component_cls=Reminders).start()


# noinspection PyUnusedLocal
def stop(argv):
    _log("Stopping the callmeback instance...")
    with open('devpack-config.yaml') as f:
        cfg = yaml.unsafe_load(f.read())

    get_coordinator(cfg, component_cls=Reminders).stop()


def _log(msg):
    print("=====callmeback: %s" % msg, file=sys.stderr)


if __name__ == '__main__':
    declare_recipe(start, stop)
