# Введение

Для начала рекомендуется почитать mail/reminders/package/readme.md для деталей того, как устроен основной образ.

# Скрипт запуска

Скрипт делает следующие вещи:

* Генерирует токен для авторизации в демоне ТВМ и записывает его в файл tvm.env, используемый всеми контейнерами (см. ниже, зачем).
* Генерирует название хоста. Зачем это нужно? Если использовать стандартное название хоста (а докер по умолчанию использует id процесса контейнера), то валится monrun при попытке определения fqdn. Почему бы не делать его фиксированным? Потому что тогда кондуктор пустит контейнер у одного разработчика, но не пустит у другого. У этих контейнеров должны быть разны хосты, но такие, чтобы monrun их понял.
* Собирает пакет и докер образ на его основе, который инсталлируется локально, но не глобально.
* Запускает набор контейнеров.

# Образ для демона

Образ для демона описан в каталоге tvmtool.  Несложно видеть, что он устанавливает tvmtool и запускает его в специальном режиме --unittest, чтобы не трогать вообще tvm. Можно поглядеть в tvmtool.conf, и убедиться, что там прописаны два приложения - наше reminders и для диска drive. Кроме того, приложение запускается в спец.режиме, с разрешением доступа удаленных машин (по умолчанию этим демоном мог бы пользоваться только localhost)

# Структура docker-compose.yml

Первое, что важно здесь - это то, что тут прописаны специальные мантры для поддержки ipv6, в противном случае к базам пробиться не удастся, да и с ZooKeeper будут проблемы. Далее, и tvmtool, и api используют tvm.env, где прописана переменная QLOUD_TVM_TOKEN. Это заставит tvmtool всегда стартовать с этим токеном, в противном случае он будет при запуске каждый раз генерировать его сам случайно. Тогда у api были бы проблемы с обращением к демону.

Далее, api.env содержит набор переменных окружения для компонента api (для worker надо будет поменять только PROGRAMNAME). По умолчанию приложение обращается к localhost:1 (потому что именно так все настроено в Qloud), а здесь он будет обращаться к tvmtool:8080. Собственно, для большинства задач это не нужно, но это нужно для корректной инициализации приложения, иначе оно просто не стартует. Настройки tvmtool прописаны в виде отдельного файла conf/application.properties, и это затем привязывается в контейнере к директории /etc/reminders/api. Почему так? Во-первых, эти настройки названы не очень правильно с точки зрения переменных окружения. Во-вторых, файл application-default.properties содержит эти настройки и он имеет более высокий приоритет по сравнению с переменными окружения. Поэтому такое разделение. PROGRAMNAME и QLOUD_ENVIRONMENT являются переменными окружения, поскольку они используются образом не только внутри приложения, но и в его скриптах.

# Проверка работоспособности

Предположим, мы запустили приложения с помощью скрипта выше. Как в него зайти и проверить, что все в порядке? Для этого можно выполнить следующую команду:

```bash
docker exec -it $(docker ps --filter name=api -q) /bin/bash
```

Фильтр нужен для того, чтобы отбросить контейнер tvmtool. Зайдя в командную оболочку, можно выполнить команду:

```bash
monrun
```

Чтобы убедиться, что все хорошо, и все проверки проходят.