# Обоснование

Зачем понадобился отдельный образ? Не так давно, если запустить таску CREATE_MAIL_RELEASE для проекта 
Reminders, а потом скачать образ:

> docker pull registry.yandex.net/mail/reminders:[Your version]

то можно было заметить, что в самом конце выкачиваются два слоя - один на 284 мегабайта, другой на 130.
Это даже если ни строчки кода не менялось. Возникает вопрос - что это за два слоя такие. Сначала с того,
что поменьше - на 130 мегабайт. Это собственно reminders.jar + все необходимые ему зависимости. Эта проблема решается
просто - разделив reminders.jar и зависимости на два каталога. При этом reminders.jar мы добавляем в образ
последним (он весит-то всего полмебагайта). Если в зависимостях не было изменений (а они у нас возникают
раз в месяц) мы получаем экономию при сборке в 130 мегабайт. Т.е. мы добавляем каждый раз в репозиторий
один слой - на полмегабайта.

Однако... это работает только если разобраться сначала с первым большим слоем. Это слой, который выполняет
команды 

> apt-get update && apt-get install -y ....

 Внезапно выяснилось, что запуск этой команды на произвольной машине приводит каждый раз к созданию нового
 слоя. И дело не только в том, что репозитории линукса постоянно обновляются, но и в том, что, видимо,
 запуск этих команд приводит к различному состоянию файловой системы (например, в логи при установках зависимостей
 может писаться разное время). Получается тупик. С одной стороны, эта команда выполняется первой,
 и так и должно быть, чтобы держать зависимости в нормальном состоянии. С другой стороны, это приводит
 к тому, что CI/CD приводит к недопустимому перерасходу пространства репозитория, ведь все следующие команды
 формируют абсолютно новые слои. Если мы произвели пять сборок 
 за день в Sandbox, изменив при этом в reminders 5 строк, мы получили расход на 5*(284+130) мегабайт. Это
 что за разбазаривание железа? Да, я догадываюсь, что там наверняка какие-то архивации производятся и сравнение
 по слоям и хранение чисто диффов, но что-то я сомневаюсь, что результат apt-get update и последующих
 бинарников удастся выделить в нормальный diff.
 
 Поэтому я и сделал этот образ. Его собирает планировщик в sandbox раз в сутки с тегом latest, а вот
 разработчики как раз и используют его. В результате, если ты меняешь код reminders, ты тратишь полмегабайта,
 а не сотни мегабайт. Это ускоряет и процесс сборки образа самого sandbox, и (гипотетически) процесс
 деплоя этого в qloud.