#!/bin/bash

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        echo "Ephemeral found"
        . /usr/lib/qloud-mail-common.sh
        (mount | grep -q "/ephemeral") &&
        (
          qloud_log yamail-logs
          qloud_log yandex
          qloud_log nginx
        )

        mkdir -p /var/log/reminders
        mkdir -p /var/log/nginx

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi

echo "Writing /etc/yandex/environment.type"
echo $QLOUD_ENVIRONMENT > /etc/yandex/environment.type

cat /etc/nginx/check_health_$PROGRAMNAME > /etc/nginx/check_health

if [[ ! -f /etc/nginx/ssl/reminders.pem ]]; then
    echo "Can't find certificate - truncating listen_https..."
    :> /etc/nginx/listen_https
fi

# If admin certificate exist - link admin config:
if [ -f /etc/nginx/ssl/reminders-admin.pem ]; then
    ln -svf /etc/nginx/sites-available/admin.conf /etc/nginx/sites-enabled
fi

exec "$@"
