import re
import json
import fileinput

pattern = re.compile(r"^https?://.+?:\d+")

urls = dict()

for line in fileinput.input():
    matched = json.loads(str(line).strip())
    for record in matched["matched"]:
        match = pattern.search(record["url"])
        if match:
            url = match.group(0)
            urls[url] = urls.get(url, 0) + 1

print(json.dumps(urls))
