import argparse
import json


parser = argparse.ArgumentParser(
    description="Take a slice of matched info in order to update just a few")
parser.add_argument("--source", type=str, required=True,
                    help="Source file to parse")
parser.add_argument("--start", type=int, default=0,
                    help="Zero-based (inclusive)")
parser.add_argument("--end", type=int, required=True,
                    help="Zero-based (exclusive)")

args = parser.parse_args()

matched = list()

with open(args.source, "r") as f:
    for line in f.readlines():
        records = json.loads(line.strip())
        matched.extend(records["matched"])

print(json.dumps({"matched": matched[args.start:args.end],
                  "total": len(matched)}))
