from pymongo import MongoClient
from bson.objectid import ObjectId
import argparse
import json
from tqdm import tqdm

parser = argparse.ArgumentParser(description="""Scan for uids.
Now, this utility was written because the original scanner did
not save the uids of the clients or client ids. But now I need them,
since I am going to use api for updating. Therefore I shall scan
the database again, but looking only for events found
by the original scanner. Since there is very little of them,
I shall have no trouble doing so in short time.""")
parser.add_argument("--host", type=str, required=True, help="The mongo host")
parser.add_argument("--port", type=int, help="The mongo port", default=27017)
parser.add_argument("--database", type=str, required=True,
                    help="Database name")
parser.add_argument("--username", type=str, required=True)
parser.add_argument("--password", type=str, required=True)
parser.add_argument("--source", type=str, required=True,
                    help="The name of the source file")

args = parser.parse_args()

matched = list()

with open(args.source, "r") as f:
    for line in f.readlines():
        matched.extend(json.loads(line.strip())["matched"])

args = parser.parse_args()

client = MongoClient(host=args.host, port=args.port,
                     username=args.username, password=args.password)

db = client.get_database(name=args.database)
coll = db["event"]

matched_actual = list()

for event in tqdm(iterable=matched):
    event_db = coll.find_one({"_id": ObjectId(event["eventId"])})
    if event_db:
        event["uid"] = event_db["uid"]
        event["cid"] = event_db["cid"]
        matched_actual.append(event)

print(json.dumps({"matched": matched_actual, "original_size": len(matched),
                  "found_actual": len(matched_actual)}))
