import json
import argparse
import requests
from tqdm import tqdm
import time

parser = argparse.ArgumentParser(prog="Update via curl")
parser.add_argument("--base_url", type=str, required=True,
                    help="The base url for the reminders api")
parser.add_argument("--source", type=str, required=True,
                    help="The source file to scan")
parser.add_argument("--rate_limit", type=int, required=True)

urls = {"http://sendbernar.mail.yandex.net:9898/":
        "https://sendbernar.mail.yandex.net:443/",
        "http://sendbernar.mail.yandex.net:9899/":
        "https://sendbernar.mail.yandex.net:443/",
        "http://sendbernar-test.mail.yandex.net:9898/":
        "https://sendbernar-test.mail.yandex.net:443/",
        "http://sendbernar-test.mail.yandex.net:9899/":
        "https://sendbernar-test.mail.yandex.net:443/",
        "http://sendbernarcorp.mail.yandex.net:9899/":
        "https://sendbernarcorp.mail.yandex.net:443/"
        }

args = parser.parse_args()

matched = list()

with open(args.source, "r") as f:
    for line in f.readlines():
        matched.extend(json.loads(line.strip())["matched"])

updated = 0
non_200_get = list()
non_200_put = list()

store_info = list()

sleep_time = float(60)/args.rate_limit
print(sleep_time)

try:
    for event in tqdm(iterable=matched):
        time.sleep(sleep_time)
        request_url = "%s/api/v1/%d/reminders/%s?id=%s" %\
                    (args.base_url, event["uid"],
                    event["cid"], event["extId"])
        r = requests.get(request_url)
        if r.status_code != 200:
            non_200_get.append([r.status_code, event])
            continue

        reminder = r.json()["result"]
        reminder_url = reminder["channels"]["callback"]["url"]
        for url in urls.keys():
            url_new = urls[url]
            if not reminder_url.startswith(url):
                continue
            reminder["channels"]["callback"]["url"] = reminder_url.replace(url,
                                                                        url_new)
            r = requests.put(request_url, data=json.dumps(reminder), headers={"Content-type": "application/json"})
            if r.status_code != 200:
                non_200_put.append([r.status_code, event])
            else:
                updated += 1
                store_info.append({"old_url": url, "reminder": reminder})
            break
except KeyboardInterrupt:
    stop = True

print(json.dumps({"updated": updated, "non_200_get": non_200_get,
                  "non_200_put": non_200_put,
                  "reminders_updated": store_info}))
