from pymongo import MongoClient
import argparse
from tqdm import tqdm
import json
from bson.objectid import ObjectId

urls = {"http://sendbernar.mail.yandex.net:9898":
        "https://sendbernar.mail.yandex.net:443",
        "http://sendbernar.mail.yandex.net:9899":
        "https://sendbernar.mail.yandex.net:443",
        "http://sendbernar-test.mail.yandex.net:9898":
        "https://sendbernar-test.mail.yandex.net:443",
        "http://sendbernar-test.mail.yandex.net:9899":
        "https://sendbernar-test.mail.yandex.net:443"
        }

parser = argparse.ArgumentParser(description="Scan the database for the urls")
parser.add_argument("--skip", type=int, default=0, help="skip records")
parser.add_argument("--limit", type=int, default=100,
                    help="How many records to handle in one sitting")
parser.add_argument("--host", type=str, required=True, help="The mongo host")
parser.add_argument("--port", type=int, help="The mongo port", default=27017)
parser.add_argument("--database", type=str, required=True,
                    help="Database name")
parser.add_argument("--username", type=str, required=True)
parser.add_argument("--password", type=str, required=True)
parser.add_argument("--source", type=str, required=True)
args = parser.parse_args()

client = MongoClient(host=args.host, port=args.port,
                     username=args.username, password=args.password)

db = client.get_database(name=args.database)
event = db["event"]


matched = list()

with open(args.source, "r") as f:
    for line in f.readlines():
        for match in json.loads(str(line).strip())["matched"]:
            matched.append(match)

updated = 0
for record in tqdm(matched):
    event_id = ObjectId(record["eventId"])
    reminder_id = ObjectId(record["reminderId"])
    event_filter = {"_id": event_id}
    event_object = event.find_one(event_filter)
    if event_object:
        reminders = event_object["reminders"]
        for reminder in reminders:
            if reminder["id"] == reminder_id:
                for url in urls.keys():
                    url_new = urls[url]
                    if reminder["url"].startswith(url):
                        reminder["url"] = reminder["url"].replace(url, url_new)
                        update = {"$set": {"reminders": reminders}}
                        executed = event.update_one(event_filter, update,
                                                    upsert=False)
                        updated += executed.modified_count
                        break
    else:
        print("Error:", event_id)

print("Updated:", updated)
