package ru.yandex.reminders.api;

import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.reminders.api.a3.bind.JsonActionResultSerializer;
import ru.yandex.reminders.api.a3.bind.JsonBinder;
import ru.yandex.reminders.api.a3.interceptors.RequestHandlesInterceptor;
import ru.yandex.reminders.logic.callmeback.CallmebackManager;

@Configuration
public class ApiTestA3ContextConfiguration {
    @Bean
    public SingleWarJetty apiJetty() {
        SingleWarJetty jetty = new SingleWarJetty();
        jetty.setLookupServletsInContext(false);

        return jetty;
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public JsonBinder jsonBinder() {
        return new JsonBinder(ApiBender.mapper);
    }

    @Bean
    public JsonActionResultSerializer jsonActionResultSerializer() {
        return new JsonActionResultSerializer(ApiBender.mapper);
    }

    @Bean
    public ApplicationInfo applicationInfo() {
        return new ApplicationInfo("tests", "unknown");
    }

    @Bean
    public RequestHandlesInterceptor requestHandlesInterceptor() {
        return new RequestHandlesInterceptor();
    }

    @Bean
    public CallmebackManager getManager() {
        return Mockito.mock(CallmebackManager.class);
    }
}
