package ru.yandex.reminders.logic.event;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.reminders.logic.update.LockManagerContextConfiguration;
import ru.yandex.reminders.mongodb.BazingaMongoClientContextConfiguration;
import ru.yandex.reminders.mongodb.TestMdaoContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaMongoClientContextConfiguration.class,
        TestMdaoContextConfiguration.class,
        LockManagerContextConfiguration.class,
})
public class EventManagerTestContextConfiguration {

    @Bean
    public EventManager eventManager() {
        return new EventManager();
    }
}
