package ru.yandex.reminders.logic.flight.airport;

import org.joda.time.DateTimeZone;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AnnotationConfigContextLoader;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;
import ru.yandex.reminders.mongodb.TestMdaoContextConfiguration;
import ru.yandex.reminders.util.TestUtils;

@ContextConfiguration(classes = TestMdaoContextConfiguration.class, loader = AnnotationConfigContextLoader.class)
@Ignore("SUBBOTNIK-1476")
@RunWith(SpringJUnit4ClassRunner.class)
public class AirportMdaoTest extends TestUtils {

    @Autowired
    private AirportMdao airportMdao;

    @Before
    public void before() {
        airportMdao.dropAndCreateCollection();
    }

    @Test
    public void saveAndFind() {
        Country country1 = new Country(
                Option.some("cname"), Option.some("cnameEn"), Option.some("cnameRu"),
                Option.some(101L));
        City city1 = new City(
                Option.some("cityName"), Option.some("cityNameEn"), Option.some("cityNameRu"),
                Option.some(10155L));
        Country country2 = new Country(
                Option.some("cname2"), Option.some("cname2En"), Option.some("cname2Ru"),
                Option.some(102L));
        City city2 = new City(
                Option.some("cityName2"), Option.some("cityName2En"), Option.some("cityName2Ru"),
                Option.some(10255L));

        airportMdao.insertOrUpdate(
                Cf.list(
                        new Airport(
                                Option.some("name"), Option.some("nameEn"), Option.some("nameRu"),
                                Option.some("IATA"), Option.some("ICAO"),
                                Option.some(country1),
                                Option.some(city1),
                                Option.some(DateTimeZone.forID("Europe/Moscow"))
                        ),
                        new Airport(
                                Option.some("name2"), Option.some("name2En"), Option.some("name2Ru"),
                                Option.some("IATA2"), Option.some("ICAO2"),
                                Option.some(country2),
                                Option.some(city2),
                                Option.some(DateTimeZone.forID("Europe/London"))
                        )
                )
        );

        ListF<Airport> airports = airportMdao.findAll();
        Assert.sizeIs(2, airports);

        checkAirport("name", "nameEn", "nameRu", "IATA", "ICAO",
                country1, city1, DateTimeZone.forID("Europe/Moscow"), airports.first());
        checkAirport("name2", "name2En", "name2Ru", "IATA2", "ICAO2",
                country2, city2, DateTimeZone.forID("Europe/London"), airports.last());

    }

    private void checkAirport(String expName, String expNameEn, String expNameRu,
            String expIata, String expIcao, Country expCountry, City expCity,
            DateTimeZone expTz, Airport airport)
    {
        Assert.some(expName, airport.getName());
        Assert.some(expNameEn, airport.getNameEn());
        Assert.some(expNameRu, airport.getNameRu());
        Assert.some(expIata, airport.getIata());
        Assert.some(expIcao, airport.getIcao());
        Assert.some(expCountry, airport.getCountry());
        Assert.some(expCity, airport.getCity());
        Assert.some(expTz, airport.getTz());
    }

}
