package ru.yandex.reminders.logic.flight.shift;

import org.bson.types.ObjectId;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AnnotationConfigContextLoader;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;
import ru.yandex.reminders.logic.reminder.Channel;
import ru.yandex.reminders.logic.reminder.SendResultStatus;
import ru.yandex.reminders.mongodb.TestMdaoContextConfiguration;
import ru.yandex.reminders.util.TestUtils;

@ContextConfiguration(classes = TestMdaoContextConfiguration.class, loader = AnnotationConfigContextLoader.class)
@RunWith(SpringJUnit4ClassRunner.class)
@Ignore("SUBBOTNIK-1476")
public class FlightShiftSendResultMdaoTest extends TestUtils {

    @Autowired
    private FlightShiftSendResultMdao flightShiftSendResultMdao;

    @Before
    public void before() {
        flightShiftSendResultMdao.dropAndCreateCollection();
    }

    @Test
    public void saveAndFind() {
        final ObjectId flightShiftId = ObjectId.get();
        final PassportUid uid1 = PassportUid.cons(312344L);
        final PassportUid uid2 = PassportUid.cons(312345L);
        final Instant remindTs = Instant.now();
        final Channel channel = Channel.SMS;
        final Option<String> msgId = Option.some("ok4479284");
        final Option<String> fail = Option.some("fail46287364");
        final Instant processTs = remindTs.plus(Duration.standardHours(3));

        FlightShiftSendResult okResult =
                FlightShiftSendResult.sent(flightShiftId, uid1, remindTs, channel, msgId, processTs);
        flightShiftSendResultMdao.save(okResult);

        findAndCheckFields(
                flightShiftId, uid1, remindTs, channel, SendResultStatus.SENT,
                msgId, Option.<String>none(), processTs, okResult.getId());

        SetF<PassportUid> uids = flightShiftSendResultMdao.findUids(flightShiftId);
        Assert.sizeIs(1, uids);
        Assert.equals(Cf.set(uid1), uids);

        FlightShiftSendResult failResult =
                FlightShiftSendResult.failed(flightShiftId, uid2, remindTs, channel, fail.get(), processTs);
        flightShiftSendResultMdao.save(failResult);

        findAndCheckFields(
                flightShiftId, uid2, remindTs, channel, SendResultStatus.FAILED,
                Option.<String>none(), fail, processTs, failResult.getId());

        uids = flightShiftSendResultMdao.findUids(flightShiftId);
        Assert.sizeIs(2, uids);
        Assert.equals(Cf.set(uid1, uid2), uids);
    }

    private FlightShiftSendResult findAndCheckFields(
            ObjectId expectedFlightShiftId, PassportUid expectedUid, Instant expectedRemindTs, Channel expectedChannel,
            SendResultStatus expectedStatus, Option<String> expectedMsgId, Option<String> expectedFail,
            Instant expectedProcessTs, ObjectId idToFind)
    {
        Option<FlightShiftSendResult> entityO = flightShiftSendResultMdao.find(idToFind);
        Assert.some(entityO);

        FlightShiftSendResult entity = entityO.get();
        checkFields(expectedFlightShiftId, expectedUid, expectedRemindTs, expectedChannel, expectedStatus,
                expectedMsgId, expectedFail, expectedProcessTs, entity);
        return entity;
    }

    private void checkFields(
            ObjectId expectedFlightShiftId, PassportUid expectedUid, Instant expectedRemindTs, Channel expectedChannel,
            SendResultStatus expectedStatus, Option<String> expectedMsgId, Option<String> expectedFail,
            Instant expectedProcessTs, FlightShiftSendResult actualEntity)
    {
        Assert.equals(expectedFlightShiftId, actualEntity.getFlightShiftId());
        Assert.equals(expectedUid, actualEntity.getUid());
        Assert.equals(expectedRemindTs, actualEntity.getSendTs());
        Assert.equals(expectedChannel, actualEntity.getChannel());
        Assert.equals(expectedStatus, actualEntity.getStatus());
        Assert.equals(expectedMsgId, actualEntity.getMsgId());
        Assert.equals(expectedFail, actualEntity.getFail());
        Assert.equals(expectedProcessTs, actualEntity.getProcessTs());
    }
}
