package ru.yandex.reminders.logic.user;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AnnotationConfigContextLoader;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;
import ru.yandex.reminders.mongodb.TestMdaoContextConfiguration;
import ru.yandex.reminders.util.TestUtils;

@ContextConfiguration(classes = TestMdaoContextConfiguration.class, loader = AnnotationConfigContextLoader.class)
@RunWith(SpringJUnit4ClassRunner.class)
@Ignore("SUBBOTNIK-1476")
public class SettingsMdaoTest extends TestUtils {
    @Resource
    private SettingsMdao settingsMdao;

    @Before
    public void before() {
        settingsMdao.dropAndCreateCollection();
    }

    @Test
    public void saveOrUpdateAndFind() {
        PassportUid uid = PassportUid.cons(12700);

        Assert.none(settingsMdao.findSettings(uid));

        settingsMdao.saveOrUpdateSettings(new Settings(uid, true));
        Assert.some(true, settingsMdao.findSettings(uid).map(Settings.getFlightRemindersDisabledF()));

        settingsMdao.saveOrUpdateSettings(new Settings(uid, false));
        Assert.some(false, settingsMdao.findSettings(uid).map(Settings.getFlightRemindersDisabledF()));
    }
}
