package ru.yandex.reminders.admin;

import org.joda.time.Instant;
import ru.yandex.reminders.util.JsonObjectUtils;
import java.util.Date;

@SuppressWarnings("unused")
class AliveAppsActionResponse {
    private final RESULT result;
    private final Version[] versions;

    public AliveAppsActionResponse(RESULT result, Version[] versions) {
        this.result = result;
        this.versions = versions;
    }

    public RESULT getResult() {
        return result;
    }

    public Version[] getVersions() {
        return versions;
    }

    @Override
    public String toString() {
        return JsonObjectUtils.objectToJsonValue(this).toString();
    }
}

enum RESULT {
    OK,
    FAIL
}

@SuppressWarnings("unused")
class Version {
    private final String version;
    private final boolean unlike;
    private final Instance[] instances;

    Version(String version, boolean unlike, Instance[] instances) {
        this.version = version;
        this.unlike = unlike;
        this.instances = instances;
    }

    public String getVersion() {
        return version;
    }

    public boolean isUnlike() {
        return unlike;
    }

    public Instance[] getInstances() {
        return instances;
    }
}

class Instance {
    private final String name;
    private final String host;
    private final String since;

    Instance(String name, String host, Instant since) {
        this.name = name;
        this.host = host;
        this.since = since.toString();
    }

    public String getName() {
        return name;
    }

    public String getHost() {
        return host;
    }

    public String getSince() {
        return since;
    }
}