package ru.yandex.reminders.admin;

import lombok.val;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.misc.io.http.HttpStatus;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class AliveAppsPingServlet extends HttpServlet {
    private final AliveAppsHolder holder;

    public AliveAppsPingServlet(AliveAppsHolder holder) {
        this.holder = holder;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        val response = getResponse(holder.aliveApps().filter(app -> "worker".equals(app.getAppName()))
                .groupBy(app -> app.getVersion()));

        resp.setContentType("text/json");
        if (response.getResult() != RESULT.OK) {
            resp.setStatus(HttpStatus.SC_500_INTERNAL_SERVER_ERROR);
        }
        resp.getWriter().write(response.toString());
    }

    private static AliveAppsActionResponse getResponse(MapF<String, ListF<AliveAppInfo>> apps) {
        val result = apps.size() <= 1 ? RESULT.OK : RESULT.FAIL;
        val sortedEntries = apps.entries().sortedBy(entry -> entry._2.size());
        // Первую версию, у которой меньше всего записей, считаем неправдоподобной
        val versions = sortedEntries.take(1).map(tuple -> getVersion(tuple, true))
                .plus(sortedEntries.drop(1).map(tuple -> getVersion(tuple, false)));
        return new AliveAppsActionResponse(result, versions.toArray(Version.class));
    }

    private static Version getVersion(Tuple2<String, ListF<AliveAppInfo>> tuple, boolean unlike) {
        return new Version(tuple._1, unlike, tuple._2.map(AliveAppsPingServlet::getInstance).toArray(Instance.class));
    }

    private static Instance getInstance(AliveAppInfo info) {
        return new Instance(info.getAppName(), info.getHostname(), info.getStartTime());
    }
}