package ru.yandex.reminders.admin;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.admin.web.Admin;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminContextConfiguration;
import ru.yandex.commune.admin.web.AdminGroups;
import ru.yandex.commune.admin.web.auth.AdminAuthenticationConfiguration;
import ru.yandex.commune.admin.web.log.LogAdminContextConfiguration;
import ru.yandex.commune.admin.web.log.LogEnvironment;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.commune.alive2.admin.AliveAppsAdminContextConfiguration;
import ru.yandex.commune.dynproperties.admin.DynamicPropertiesAdminContextConfiguration;
import ru.yandex.commune.mongo3.admin.explorer.MongoExplorerAdminPage;
import ru.yandex.commune.mongo3.admin.schema.MongoSchemaCheckerAdminContextConfiguration;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreterFactory;
import ru.yandex.commune.script.cosher.server.ScriptTelnetServer;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.web.servlet.PidServlet;
import ru.yandex.misc.web.servlet.PingConfigurableServlet;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.reminders.mongodb.MongoCheckWorker;
import ru.yandex.reminders.mongodb.MongoDbContextConfiguration;
import ru.yandex.reminders.mongodb.MongoPingServlet;

import javax.servlet.http.HttpServlet;

/**
 * @author dbrylev
 */
@Configuration
@Import({
    AdminContextConfiguration.class,
    LogAdminContextConfiguration.class,
    AliveAppsAdminContextConfiguration.class,
    MongoDbContextConfiguration.class,
    MongoSchemaCheckerAdminContextConfiguration.class,
    DynamicPropertiesAdminContextConfiguration.class,
    ZkAdminContextConfiguration.class

})
public class RemindersAdminContextConfiguration {
    @Bean
    public AdminAuthenticationConfiguration adminAuthenticationConfiguration(EnvironmentType environmentType) {
        AdminAuthenticationConfiguration conf = new AdminAuthenticationConfiguration();
        conf.addNoAuthUriPatternsForLocalhost("/ping-mongo/*", "/z/log/grep/*", "/ping-alive-apps");
        return Option.when(environmentType == EnvironmentType.PRODUCTION, conf).getOrNull();
    }

    @Admin
    @Bean
    public SingleWarJetty singleWarJetty(@Value("${admin.jetty.port}") int port, MongoCheckWorker mongoCheckWorker,
                                         AliveAppsHolder holder) {
        SingleWarJetty singleWarJetty = new SingleWarJetty();

        singleWarJetty.setMaxThreads(30);
        singleWarJetty.setHttpPort(port);
        singleWarJetty.setLookupServletsInContext(true);

        singleWarJetty.addServletMapping("/pid/*", new PidServlet());
        singleWarJetty.addServletMapping("/ping/*", adminConfigurableServlet());
        singleWarJetty.addServletMapping("/ping-mongo/*", mongoPingServlet(mongoCheckWorker));
        singleWarJetty.addServletMapping("/ping-alive-apps", aliveAppsServlet(holder));

        return singleWarJetty;
    }

    private HttpServlet aliveAppsServlet(AliveAppsHolder holder) {
        return new AliveAppsPingServlet(holder);
    }

    @Bean
    public MongoExplorerAdminPage mongoBrowserAdminPage(MongoClient mongoClient, AdminApp adminApp) {
        MongoExplorerAdminPage page = new MongoExplorerAdminPage();
        page.addInstance("reminders", mongoClient);

        adminApp.registerAdminPage("MongoDB Browser", AdminGroups.DB, page);

        return page;
    }

    @Bean
    public ScriptTelnetServer scriptTelnetServer(@Value("${scriptTelnetServer.port}") int port) {
        return new ScriptTelnetServer(new NashornInterpreterFactory(), port, false);
    }

    @Bean
    public PingConfigurableServlet adminConfigurableServlet() {
        return new PingConfigurableServlet();
    }

    @Bean
    public MongoPingServlet mongoPingServlet(MongoCheckWorker mongoCheckWorker) {
        return new MongoPingServlet(mongoCheckWorker);
    }

    @Bean
    public LogEnvironment logEnvironment() {
        return new RemindersLogEnvironment();
    }
}
