package ru.yandex.reminders.admin;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.commune.admin.web.log.LogEnvironment;

/**
 * @author dbrylev
 */
public class RemindersLogEnvironment implements LogEnvironment {

    @Value("${log.dir}/")
    private String logDir;

    @Override
    public String getLogFileNamePrefix() {
        return "reminders";
    }

    @Override
    public String getDefaultLogFileName() {
        return "reminders.log";
    }

    @Override
    public String getDefaultLogFolder() {
        return logDir;
    }
}
