package ru.yandex.reminders.api;

import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.reminders.api.a3.bind.JsonActionResult;

@JsonActionResult(resultFieldName = "error")
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class ErrorResult implements HttpStatusCodeSource {
    @BenderPart
    private final String name;
    @BenderPart
    private final String message;
    private final int httpStatusCode;

    public ErrorResult(String name, String message, int httpStatusCode) {
        this.name = name;
        this.message = message;
        this.httpStatusCode = httpStatusCode;
    }

    @Override
    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    public String getMessage() {
        return message;
    }
}
