package ru.yandex.reminders.api.a3;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpStatus;

public class SafeMessageAnyExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(
            WebRequest webRequest, ActionInvocationContext context,
            ExceptionResolver exceptionResolver, Exception exception)
    {
        context.getHttpContext().setStatusCode(HttpStatus.SC_500_INTERNAL_SERVER_ERROR);

        return Option.of(new ErrorResult(
                CommonErrorNames.UNKNOWN, "Unexpected error occurred.",
                Option.of(ExceptionUtils.getStackTrace(exception)), Option.empty()));
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
