package ru.yandex.reminders.api.a3.bind;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.BenderXmlOrJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyMarshallerContext;

import java.io.OutputStream;

public class JsonActionResultSerializer extends AbstractResultSerializer {

    private final BenderMapper benderMapper;

    public JsonActionResultSerializer(BenderMapper benderMapper) {
        this.benderMapper = benderMapper;
    }

    @Override
    protected boolean supports(Object result) {
        return result.getClass().isAnnotationPresent(JsonActionResult.class);
    }

    @Override
    protected void serializeSafely(Object result, ActionInvocationContext context, OutputStream outputStream) {
        if (result instanceof HttpStatusCodeSource) {
            context.getHttpContext().setStatusCode(((HttpStatusCodeSource) result).getHttpStatusCode());
        }
        BenderJsonWriter jw = BenderXmlOrJsonWriter.json(outputStream).getJson();

        jw.writeObjectStart();
        jw.writeFieldName("invocation-info");

        jw.writeObjectStart();
        for (Tuple2<String, Object> t : context.getAdditionalAttrs()) {
            jw.writeFieldName(t._1);
            jw.writeString(t._2.toString());
        }
        jw.writeObjectEnd();

        String resultFieldName = result.getClass().getAnnotation(JsonActionResult.class).resultFieldName();

        jw.writeFieldName(resultFieldName);
        benderMapper.serializeJson(result, jw, new EmptyMarshallerContext());
        jw.writeObjectEnd();

        jw.flush();
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
