package ru.yandex.reminders.api.a3.bind;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.*;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpStatus;

public class JsonBinderParseExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(
            WebRequest webRequest, ActionInvocationContext context,
            ExceptionResolver exceptionResolver, Exception exception)
    {
        if (exception instanceof JsonBinderParseException) {
            context.getHttpContext().setStatusCode(HttpStatus.SC_400_BAD_REQUEST);

            return Option.of(new ErrorResult(
                    CommonErrorNames.VALIDATE, "Unexpected json request format.",
                    Option.of(ExceptionUtils.getStackTrace(exception)), Option.empty()));
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
