package ru.yandex.reminders.api.a3.interceptors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.parameter.Parameter;
import ru.yandex.commune.a3.action.parameter.SimpleBindingParameters;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class LogActionParametersInterceptor implements ActionInvocationInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(LogActionParametersInterceptor.class);

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        ListF<String> pairs = Cf.arrayList();
        for (Parameter param : invocation.getParameters().sortedBy(isSimpleBindingF().notF().asFunction())) {
            pairs.add(getName(param).plus(getValue(param)).mkString("="));
        }

        logger.debug("Invoking action {} with parameters: {}",
                invocation.getActionDescriptor().getName(), pairs.mkString("[", ", ", "]"));
        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER;
    }

    private static Option<String> getName(Parameter param) {
        ParameterBinder binder = param.getDescriptor().getParameterBinder();

        if (binder instanceof LoggingParameterBinder) {
            return ((LoggingParameterBinder) binder).getNameForLogging(param);
        }
        Option<SimpleBindingParameters> binding = param.getDescriptor().getSimpleBindingParameters();

        return binding.isDefined() ? Option.some(binding.get().getName()) : Option.<String>none();
    }

    private static Option<String> getValue(Parameter param) {
        ParameterBinder binder = param.getDescriptor().getParameterBinder();

        if (binder instanceof LoggingParameterBinder) {
            return ((LoggingParameterBinder) binder).getValueForLogging(param);
        }
        return param.getValue().isDefined() ? Option.some(param.getValue().get().toString()) : Option.<String>none();
    }

    private static Function1B<Parameter> isSimpleBindingF() {
        return new Function1B<Parameter>() {
            public boolean apply(Parameter p) {
                return p.getDescriptor().isSimpleBinding();
            }
        };
    }
}
