package ru.yandex.reminders.api.a3.interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.reminders.mongodb.MongoCheckWorker;

public class MongoDbAvailabilityInterceptor implements ActionInvocationInterceptor {

    @Autowired
    private MongoCheckWorker mongoCheckWorker;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        if (!mongoCheckWorker.isAvailable()) {
            invocation.getContext().addAdditionalAttr("master-db-unavailable", "true");
        }
        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER;
    }
}
