package ru.yandex.reminders.api.a3.interceptors;

import lombok.val;
import org.joda.time.Duration;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.misc.log.mlf.ndc.Ndc;
import ru.yandex.misc.log.reqid.RequestIdStack;
import ru.yandex.misc.thread.ThreadLocalTimeout;
import ru.yandex.misc.thread.WhatThreadDoes;
import ru.yandex.misc.thread.WithTlTimeoutInMillis;

public class RequestHandlesInterceptor implements ActionInvocationInterceptor {
    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        val actionName = invocation.getActionDescriptor().getName();

        val a = invocation.getActionDescriptor().getAnnotationO(WithTlTimeoutInMillis.class);
        val timeout = a.toOptional().map(v -> Duration.millis(v.value())).orElse(Duration.standardSeconds(9));

        val ndcHandle = Ndc.push("a=" + actionName);
        val requestIdStackHandle = RequestIdStack.pushIfNotYet();

        val wtdHandle = WhatThreadDoes.push("action " + actionName);
        val tltHandle = ThreadLocalTimeout.push(timeout, "action " + actionName);

        try {
            return invocation.invoke();
        } finally {
            requestIdStackHandle.popSafely();
            ndcHandle.popSafely();
            wtdHandle.popSafely();
            tltHandle.popSafely();
        }
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER;
    }
}
