package ru.yandex.reminders.api.calendar;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.AnyExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class ApiCalendarContextConfiguration {

    @Bean
    public ActionApp calendarActionApp(ApplicationContext context, ApplicationInfo info) {
        ListF<ExceptionHandler> exceptionHandlers = Cf.list(
                new A3ExceptionHandler(),
                new AnyExceptionHandler());

        return ActionConfigurator.configure(
                Cf.<Object>list(calendarActions()),
                DefaultActionConfiguration.defaultConfiguration(context, info).setExceptionHandlers(exceptionHandlers));
    }

    @Bean
    public ActionInvocationServlet calendarActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("calendarActionApp") ActionApp actionApp)
    {
        ActionInvocationServlet servlet = actionApp.createServlet();
        jetty.addServletMapping("/calendar/*", servlet);
        return servlet;
    }

    @Bean
    public CalendarActions calendarActions() {
        return new CalendarActions();
    }

    @Bean
    public CalendarEventManager calendarEventManager() {
        return new CalendarEventManager();
    }
}
