package ru.yandex.reminders.api.calendar;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.reminders.api.StatusResult;

@ActionContainer
public class CalendarActions {

    @Autowired
    private CalendarEventManager calendarEventManager;

    @Action
    public EventsInfo findEvents(
            @RequestParam("uid") PassportUid uid,
            @RequestParam("from") LocalDate from,
            @RequestParam("till") LocalDate till,
            @RequestParam("tz") DateTimeZone tz)
    {
        return new EventsInfo(calendarEventManager.findEvents(uid, from, till, tz));
    }

    @Action
    public StatusResult deleteEvent(
            @RequestParam("uid") PassportUid uid,
            @RequestParam("clientId") String clientId,
            @RequestParam("externalId") String externalId,
            @RequestParam("idx") long idx)
    {
        calendarEventManager.deleteEvent(uid, clientId, externalId, idx);
        return StatusResult.OK;
    }
}
