package ru.yandex.reminders.api.calendar;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.reminders.logic.event.EventId;
import ru.yandex.reminders.logic.reminder.Channel;

@BenderBindAllFields
public class EventInfo {
    private final String clientId;
    private final String externalId;
    private final long idx;

    private final DateTime start;

    private final String name;
    private final Option<String> description;
    private final ListF<Channel> reminderChannels;

    public EventInfo(
            EventId eventId,
            DateTime start, String name, Option<String> description, ListF<Channel> reminderChannels)
    {
        this.clientId = eventId.getCid();
        this.externalId = eventId.getExtId();
        this.idx = eventId.getIdx();
        this.start = start;
        this.name = name;
        this.description = description;
        this.reminderChannels = reminderChannels;
    }

    public static Function1B<EventInfo> localStartInF(final LocalDateTime from, final LocalDateTime till) {
        return e -> !from.isAfter(e.start.toLocalDateTime()) && e.start.toLocalDateTime().isBefore(till);
    }

    public static Function1B<EventInfo> absoluteStartInF(final ReadableInstant from, final ReadableInstant till) {
        return e -> !from.isAfter(e.start) && e.start.isBefore(till);
    }
}
