package ru.yandex.reminders.api.callmeback;

import lombok.val;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.security.SecurityExceptionHandler;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.reminders.api.a3.SafeMessageAnyExceptionHandler;
import ru.yandex.reminders.api.a3.bind.JsonBinderParseExceptionHandler;
import ru.yandex.reminders.tvm.TvmClient;

@Configuration
public class ApiCallmebackContextConfiguration {
    @Bean
    public ActionApp callmebackActionApp(ApplicationContext context, ApplicationInfo info,
                                         CallmebackActions callmebackActions,
                                         TvmClient client,
                                         @Value("${callmeback.worker.tvm.id:-}") long tvmId) {
        val exceptionHandlers = Cf.list(
                new SecurityExceptionHandler(),
                new CallmebackRetryExceptionHandler(),
                new JsonBinderParseExceptionHandler(),
                new SafeMessageAnyExceptionHandler());

        return ActionConfigurator.configure(
                Cf.list(callmebackActions),
                DefaultActionConfiguration.defaultConfiguration(context, info)
                        .setExceptionHandlers(exceptionHandlers)
                        .addInvocationInterceptor(new TvmInvocationInterceptor(client, tvmId)));
    }

    @Bean
    public ActionInvocationServlet callmebackActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("callmebackActionApp") ActionApp actionApp)
    {
        val servlet = actionApp.createServlet();
        jetty.addServletMapping("/callmeback/*", servlet);
        return servlet;
    }

    @Bean
    public CallmebackActions callmebackActions() {
        return new CallmebackActions();
    }
}