package ru.yandex.reminders.api.callmeback;

import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.thread.WithTlTimeoutInMillis;
import ru.yandex.reminders.api.StatusResult;
import ru.yandex.reminders.api.a3.bind.BindJson;
import ru.yandex.reminders.log.TskvFields;
import ru.yandex.reminders.log.TskvLogDataSource;
import ru.yandex.reminders.logic.callmeback.in.CallbackRequest;
import ru.yandex.reminders.logic.event.SpecialClientIds;
import ru.yandex.reminders.logic.reminder.ReminderSendManager;

@ActionContainer
@Slf4j
public class CallmebackActions implements TskvLogDataSource {
    @Autowired
    private ReminderSendManager reminderSendManager;

    @Action
    @WithTlTimeoutInMillis(3000)
    @Path(methods = HttpMethod.GET, value = "/ping/")
    public StatusResult ping() {
        return new StatusResult("OK; ping callmeback");
    }

    @Action
    @WithTlTimeoutInMillis(3000)
    @Path(methods = HttpMethod.POST, value = "/send/")
    public StatusResult sendReminder (
            @BindJson CallbackRequest request)
    {
        log.info("Received request: {}", request);
        val result =  reminderSendManager.sendReminder(request);
        if (result.isSent()) {
            return new StatusResult("OK; Sent successfully");
        }

        val message = result.tskvLogData().toString();

        if (result.isTryAgain()) {
            throw new CallmebackRetryException(message);
        }

        throw new A3Exception("The call failed, do not retry", message);
    }

    @Override
    public Tuple2List<String, String> tskvLogData() {
        return Tuple2List.fromPairs(TskvFields.CID, SpecialClientIds.CALLMEBACK);
    }
}