package ru.yandex.reminders.api.callmeback;

import org.apache.http.HttpStatus;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;

public class CallmebackRetryExceptionHandler extends A3ExceptionHandler {
    private static final String DO_NOT_RETRY_HEADER = "X-Ya-CallMeBack-Notify-Reject";
    @Override
    public Option<?> handleException(WebRequest request, ActionInvocationContext context, ExceptionResolver resolver, Exception exception) {
        if (!(exception instanceof  CallmebackRetryException)) {
            context.getHttpContext().setHeader(DO_NOT_RETRY_HEADER, "true");
            return super.handleException(request, context, resolver, exception);
        }
        return handleA3Exception((A3Exception) exception, context, HttpStatus.SC_INTERNAL_SERVER_ERROR);
    }
}
